/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.arcticmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.arcticmobs.entity.EntityReiver;
import com.lycanitesmobs.arcticmobs.entity.EntityTundra;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityWendigo
extends EntityCreatureBase
implements IMob,
IGroupIce {
    EntityAIWander wanderAI;

    public EntityWendigo(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 3;
        this.experience = 10;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.setWidth = 1.0f;
        this.setHeight = 4.5f;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this).setSink(true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(1.0).setRate(100).setRange(16.0f).setMinChaseDistance(8.0f));
        this.wanderAI = new EntityAIWander(this);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.wanderAI);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityReiver.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityBlaze.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityMagmaCube.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupFire.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 30.0);
        baseAttributes.put("movementSpeed", 0.16);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150433_aE), 0.5f).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150403_cj), 0.25f).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("frostyfur")), 0.75f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("tundracharge")), 0.75f));
    }

    @Override
    public void func_70636_d() {
        Block block;
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0) {
            int trailHeight = 1;
            int trailWidth = 1;
            if (this.getSubspeciesIndex() >= 3) {
                trailWidth = 3;
            }
            for (int y = 0; y < trailHeight; ++y) {
                Block block2 = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, y, 0)).func_177230_c();
                if (block2 == null || block2 != Blocks.field_150350_a && block2 != Blocks.field_150480_ab && block2 != Blocks.field_150431_aC && block2 != Blocks.field_150329_H && block2 != ObjectManager.getBlock("scorchfire") && block2 != ObjectManager.getBlock("doomfire")) continue;
                if (trailWidth == 1) {
                    this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, y, 0), ObjectManager.getBlock("frostfire").func_176223_P());
                    continue;
                }
                for (int x = -(trailWidth / 2); x < trailWidth / 2 + 1; ++x) {
                    for (int z = -(trailWidth / 2); z < trailWidth / 2 + 1; ++z) {
                        this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(x, y, z), ObjectManager.getBlock("frostfire").func_176223_P());
                    }
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.isMoving() && this.field_70173_aa % 5 == 0 && (block = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c()) == Blocks.field_150355_j) {
            this.func_130014_f_().func_175656_a(this.func_180425_c().func_177982_a(0, -1, 0), Blocks.field_150432_aD.func_176223_P());
        }
        if (this.func_130014_f_().field_72995_K) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SNOW_SHOVEL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SNOW_SHOVEL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.field_70173_aa % 10 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SNOW_SHOVEL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        int waterWeight = 10;
        BlockPos pos = new BlockPos(x, y, z);
        if (ObjectManager.getBlock("ooze") != null && this.func_130014_f_().func_180495_p(pos).func_177230_c() == ObjectManager.getBlock("ooze")) {
            return (super.getBlockPathWeight(x, y, z) + 1.0f) * (float)(waterWeight + 1);
        }
        if (this.func_70638_az() != null) {
            return super.getBlockPathWeight(x, y, z);
        }
        if (this.func_70090_H()) {
            return -999999.0f;
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityReiver.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityTundra projectile = new EntityTundra(this.func_130014_f_(), (EntityLivingBase)this);
        projectile.setProjectileScale(2.0f);
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
        float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.func_130014_f_().func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("ooze")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76421_d) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76438_s) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

